/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.tree;

import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.event.TreePropertyListener;
import com.ibm.hwmca.ui.bonsai.event.EventQueueListener;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.tree.NavigationTreeNode;
import com.ibm.hwmca.ui.bonsai.tree.NavigationTreeNodeBean;
import com.ibm.psw.wcl.components.tree.DefaultExtendedTreeModel;
import com.ibm.psw.wcl.core.AContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NavigationTreeModel
extends DefaultExtendedTreeModel
implements EventQueueListener,
TreePropertyListener {
    private final Object DATA_LOCK = new Object();
    private String actionClassName;
    private UserObject userObj;
    private boolean reloadPending = false;

    public NavigationTreeModel(String actionClassName, UserObject userObj) {
        super((TreeNode)NavigationTreeModel.buildNavigationTree(userObj), false);
        this.actionClassName = actionClassName;
        this.userObj = userObj;
    }

    public UserObject getUserObject() {
        return this.userObj;
    }

    public void setTreeSelection(String nodeId, AContext context) {
        NavigationTreeNode node = this.findNode((NavigationTreeNode)this.getRoot(), nodeId);
        if (node == null) {
            return;
        }
        TreePath selPath = new TreePath(node.getPath());
        this.setSelectionPath(selPath, context);
        this.expandPath(selPath, context);
    }

    public TreePath getValidPath(TreePath path) {
        if (path == null || path.getPathCount() == 0) {
            return path;
        }
        if (this.isValidPath(path)) {
            return path;
        }
        return this.getValidPath(path.getParentPath());
    }

    public boolean isValidPath(TreePath path) {
        Object[] pathNodes = path.getPath();
        NavigationTreeNode node = (NavigationTreeNode)this.getRoot();
        int index = -1;
        for (int i = 1; i < pathNodes.length; ++i) {
            index = node.getChildIndexById(((NavigationTreeNode)pathNodes[i]).getId());
            if (index < 0) {
                return false;
            }
            node = (NavigationTreeNode)node.getChildAt(index);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEmpty() {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            if (this.reloadPending && this.userObj.isModelVisible(this.actionClassName)) {
                UIRefreshManager.refresh(3, this.userObj.getHMCSession());
            }
            this.reloadPending = false;
        }
    }

    public void replace(BonsaiTreeNode oldNode, BonsaiTreeNode newNode) {
        if (!newNode.isShown(this.userObj, true)) {
            this.performRemove(oldNode);
            return;
        }
        this.performReplace(newNode, true);
    }

    public void remove(BonsaiTreeNode bNode) {
        this.performRemove(bNode);
    }

    public void statusChange(BonsaiTreeNode node) {
        if (!node.isShown(this.userObj, true)) {
            this.performRemove(node);
            return;
        }
        this.performReplace(node, true);
    }

    public void uiinfoChange(BonsaiTreeNode node) {
        if (!node.isShown(this.userObj, true)) {
            this.performRemove(node);
            return;
        }
        this.performReplace(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRemove(BonsaiTreeNode bonsaiNode) {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            BonsaiTreeNode bonsaiParent = bonsaiNode.getParent();
            boolean parentDisplayable = true;
            try {
                if (bonsaiParent != null) {
                    parentDisplayable = bonsaiParent.isShown(this.userObj, true);
                }
            }
            catch (InvalidIdException iiEx) {
                parentDisplayable = false;
            }
            if (!parentDisplayable) {
                this.performRemove(bonsaiParent);
                return;
            }
            NavigationTreeNode node = this.findNode((NavigationTreeNode)this.getRoot(), bonsaiNode.getId());
            if (node == null) {
                return;
            }
            NavigationTreeNode parent = (NavigationTreeNode)node.getParent();
            TreePath selectionPath = this.getSelectionPath();
            Vector visiblePaths = this.getVisiblePaths();
            this.reloadPending = true;
            this.removeNodeFromParent(node);
            this.restoreState(selectionPath, visiblePaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performReplace(BonsaiTreeNode bNode, boolean reloadOnChildrenOnly) {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            NavigationTreeNode node = this.findNode((NavigationTreeNode)this.getRoot(), bNode.getId());
            if (node == null) {
                BonsaiTreeNode parent = bNode.getParent();
                if (parent == null) {
                    TreePath selectionPath = this.getSelectionPath();
                    Vector visiblePaths = this.getVisiblePaths();
                    this.setRoot(NavigationTreeModel.buildNavigationTree(this.userObj));
                    this.restoreState(selectionPath, visiblePaths);
                    this.reloadPending = true;
                } else {
                    this.performReplace(parent, false);
                }
                return;
            }
            NavigationTreeNode parent = (NavigationTreeNode)node.getParent();
            TreePath selectionPath = this.getSelectionPath();
            Vector visiblePaths = this.getVisiblePaths();
            TreePath path = new TreePath(reloadOnChildrenOnly ? node.getPath() : parent.getPath());
            this.reloadPending = true;
            int index = this.getIndexOfChild(parent, node);
            this.removeNodeFromParent(node);
            List nodeList = new ArrayList<BonsaiTreeNode>(1);
            nodeList.add(bNode);
            nodeList = NavigationTreeModel.buildNavigationTrees(nodeList, this.userObj);
            if (!nodeList.isEmpty()) {
                node = (NavigationTreeNode)nodeList.get(0);
                this.insertNodeInto(node, parent, index);
            }
            this.restoreState(selectionPath, visiblePaths);
        }
    }

    private void restoreState(TreePath selectionPath, Vector expansionsToRestore) {
        this.setSelectionPath(this.getValidPath(selectionPath), null);
        TreePath path = null;
        Iterator i = expansionsToRestore.iterator();
        while (i.hasNext()) {
            Object hash;
            path = (TreePath)i.next();
            if (!this.isValidPath(path) || this.expandedPaths.containsKey(hash = this.getTreePathHashKey(path))) continue;
            this.expandedPaths.put(hash, path);
            this.fireTreeExpanded(path, null);
        }
    }

    private NavigationTreeNode findNode(NavigationTreeNode node, String id) {
        if (id.equals(node.getId())) {
            return node;
        }
        Iterator i = node.getChildren().iterator();
        while (i.hasNext()) {
            node = this.findNode((NavigationTreeNode)i.next(), id);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    static NavigationTreeNode buildNavigationTree(UserObject userObj) {
        NavigationTreeNode root = new NavigationTreeNode(new NavigationTreeNodeBean("hidden.root.node", "hidden", "", null));
        Iterator i = NavigationTreeModel.buildNavigationTrees(userObj).iterator();
        while (i.hasNext()) {
            root.add((NavigationTreeNode)i.next());
        }
        return root;
    }

    static List buildNavigationTrees(UserObject userObj) {
        return NavigationTreeModel.buildNavigationTrees(BonsaiTreeManager.getBonsaiTreeManager().getRootNodes(), userObj);
    }

    static List buildNavigationTrees(List nodes, UserObject userObj) {
        ArrayList<NavigationTreeNode> navNodes = new ArrayList<NavigationTreeNode>(nodes.size());
        BonsaiTreeNode bNode = null;
        NavigationTreeNode nNode = null;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            bNode = (BonsaiTreeNode)i.next();
            if (!bNode.isShown(userObj, true)) continue;
            nNode = new NavigationTreeNode(bNode.getNavigationTreeNodeBean(userObj));
            nNode.addAll(NavigationTreeModel.buildNavigationTrees(bNode.getChildren(), userObj));
            navNodes.add(nNode);
        }
        return navNodes;
    }
}

